/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.request;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.properties.annotations.OutputPropertyRoleAnnotationHandler;
import org.gradle.api.problems.internal.DefaultProblems;
import org.gradle.api.problems.internal.ExceptionProblemRegistry;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.ProblemSummarizer;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.cache.internal.DefaultCrossBuildInMemoryCacheFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.dispatch.StreamCompletion;
import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.instantiation.PropertyRoleAnnotationHandler;
import org.gradle.internal.instantiation.generator.DefaultInstantiatorFactory;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.remote.internal.hub.StreamFailureHandler;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.process.internal.worker.RequestHandler;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.child.WorkerLogEventListener;
import org.gradle.process.internal.worker.child.WorkerLoggingProtocol;
import org.gradle.process.internal.worker.problem.WorkerProblemEmitter;
import org.gradle.process.internal.worker.problem.WorkerProblemProtocol;
import org.gradle.process.internal.worker.request.Request;
import org.gradle.process.internal.worker.request.RequestArgumentSerializers;
import org.gradle.process.internal.worker.request.RequestProtocol;
import org.gradle.process.internal.worker.request.RequestSerializerRegistry;
import org.gradle.process.internal.worker.request.ResponseProtocol;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderCache;
import org.gradle.tooling.internal.provider.serialization.DefaultPayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.serialization.ModelClassLoaderFactory;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderFactory;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.WellKnownClassLoaderRegistry;

public class WorkerAction
implements Action<WorkerProcessContext>,
Serializable,
RequestProtocol,
StreamFailureHandler,
Stoppable,
StreamCompletion {
    private final String workerImplementationName;
    private transient CountDownLatch completed;
    private transient ResponseProtocol responder;
    private transient WorkerLogEventListener workerLogEventListener;
    private transient RequestHandler<Object, Object> implementation;
    private transient InstantiatorFactory instantiatorFactory;
    private transient Exception failure;

    public WorkerAction(Class<?> workerImplementation) {
        this.workerImplementationName = workerImplementation.getName();
    }

    @Nonnull
    private static PayloadSerializer createPayloadSerializer() {
        ClassLoaderCache classLoaderCache = new ClassLoaderCache();
        return new PayloadSerializer((PayloadClassLoaderRegistry)new WellKnownClassLoaderRegistry((PayloadClassLoaderRegistry)new DefaultPayloadClassLoaderRegistry(classLoaderCache, (PayloadClassLoaderFactory)new ModelClassLoaderFactory())));
    }

    public void execute(WorkerProcessContext workerProcessContext) {
        this.completed = new CountDownLatch(1);
        ObjectConnection connection = workerProcessContext.getServerConnection();
        connection.addIncoming(RequestProtocol.class, (Object)this);
        this.responder = (ResponseProtocol)connection.addOutgoing(ResponseProtocol.class);
        this.workerLogEventListener = (WorkerLogEventListener)workerProcessContext.getServiceRegistry().get(WorkerLogEventListener.class);
        RequestArgumentSerializers argumentSerializers = new RequestArgumentSerializers();
        try {
            ServiceRegistry parentServices = workerProcessContext.getServiceRegistry();
            if (this.instantiatorFactory == null) {
                this.instantiatorFactory = new DefaultInstantiatorFactory((CrossBuildInMemoryCacheFactory)new DefaultCrossBuildInMemoryCacheFactory((ListenerManager)new DefaultListenerManager(Scope.Global.class)), Collections.emptyList(), (PropertyRoleAnnotationHandler)new OutputPropertyRoleAnnotationHandler(Collections.emptyList()));
            }
            CloseableServiceRegistry serviceRegistry = ServiceRegistryBuilder.builder().displayName("worker action services").parent(parentServices).provider(registration -> {
                registration.add(RequestArgumentSerializers.class, (Object)argumentSerializers);
                registration.add(InstantiatorFactory.class, (Object)this.instantiatorFactory);
                registration.add(InternalProblems.class, (Object)new DefaultProblems((ProblemSummarizer)new WorkerProblemEmitter((WorkerProblemProtocol)this.responder), null, CurrentBuildOperationRef.instance(), new ExceptionProblemRegistry(), null, (Instantiator)this.instantiatorFactory.decorateLenient(), WorkerAction.createPayloadSerializer()));
            }).build();
            Class<?> workerImplementation = Class.forName(this.workerImplementationName);
            this.implementation = (RequestHandler)Cast.uncheckedNonnullCast((Object)this.instantiatorFactory.inject((ServiceLookup)serviceRegistry).newInstance(workerImplementation, new Object[0]));
        }
        catch (Exception e) {
            this.failure = e;
        }
        if (this.failure == null) {
            connection.useParameterSerializers(RequestSerializerRegistry.create(this.getClass().getClassLoader(), argumentSerializers));
        } else {
            connection.useParameterSerializers(RequestSerializerRegistry.createDiscardRequestArg());
            this.responder.infrastructureFailed(this.failure);
        }
        connection.connect();
        try {
            this.completed.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.completed.countDown();
        CurrentBuildOperationRef.instance().clear();
    }

    public void endStream() {
        this.stop();
    }

    @Override
    public void runThenStop(Request request) {
        try {
            this.run(request);
        }
        finally {
            this.stop();
        }
    }

    @Override
    public void run(final Request request) {
        if (this.failure != null) {
            return;
        }
        CurrentBuildOperationRef.instance().with(request.getBuildOperation(), () -> {
            try {
                Object result;
                try {
                    result = this.workerLogEventListener.withWorkerLoggingProtocol((WorkerLoggingProtocol)this.responder, (Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return WorkerAction.this.implementation.run(request.getArg());
                        }
                    });
                }
                catch (Throwable failure) {
                    if (failure instanceof NoClassDefFoundError) {
                        this.responder.infrastructureFailed(failure);
                    } else {
                        this.responder.failed(failure);
                    }
                    return;
                }
                this.responder.completed(result);
            }
            catch (Throwable t) {
                this.responder.infrastructureFailed(t);
            }
        });
    }

    public void handleStreamFailure(Throwable t) {
        this.responder.failed(t);
    }
}

