/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public interface TypeValidationContext {
    public static final TypeValidationContext NOOP = new TypeValidationContext(){

        @Override
        public void visitTypeProblem(Severity severity, Class<?> type, String message) {
        }

        @Override
        public void visitPropertyProblem(Severity severity, @Nullable String parentProperty, @Nullable String property, String message) {
        }
    };

    public void visitTypeProblem(Severity var1, Class<?> var2, String var3);

    default public void visitPropertyProblem(Severity severity, String message) {
        this.visitPropertyProblem(severity, null, null, message);
    }

    default public void visitPropertyProblem(Severity severity, @Nullable String property, String message) {
        this.visitPropertyProblem(severity, null, property, message);
    }

    public void visitPropertyProblem(Severity var1, @Nullable String var2, @Nullable String var3, String var4);

    public static class ReplayingTypeValidationContext
    implements TypeValidationContext {
        private final List<BiConsumer<String, TypeValidationContext>> problems = new ArrayList<BiConsumer<String, TypeValidationContext>>();

        @Override
        public void visitTypeProblem(Severity severity, Class<?> type, String message) {
            this.problems.add((ownerProperty, validationContext) -> validationContext.visitTypeProblem(severity, type, message));
        }

        @Override
        public void visitPropertyProblem(Severity severity, @Nullable String parentProperty, @Nullable String property, String message) {
            this.problems.add((ownerProperty, validationContext) -> validationContext.visitPropertyProblem(severity, ReplayingTypeValidationContext.combineParents(ownerProperty, parentProperty), property, message));
        }

        public void replay(@Nullable String ownerProperty, TypeValidationContext target) {
            this.problems.forEach(problem -> problem.accept(ownerProperty, target));
        }

        @Nullable
        private static String combineParents(@Nullable String grandParentProperty, @Nullable String parentProperty) {
            return grandParentProperty == null ? parentProperty : (parentProperty == null ? grandParentProperty : grandParentProperty + "." + parentProperty);
        }
    }

    public static enum Severity {
        WARNING("Warning"),
        CACHEABILITY_WARNING("Warning"),
        ERROR("Error");

        private final String displayName;

        private Severity(String displayName) {
            this.displayName = displayName;
        }

        public Severity toReportableSeverity() {
            return this == CACHEABILITY_WARNING ? WARNING : this;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

