/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.resolver;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.kotlin.dsl.resolver.FetchParameters;
import org.gradle.kotlin.dsl.resolver.GradleInstallation;
import org.gradle.kotlin.dsl.resolver.KotlinBuildScriptModelRequest;
import org.gradle.kotlin.dsl.resolver.KotlinBuildScriptModelRequestKt;
import org.gradle.kotlin.dsl.resolver.KotlinBuildScriptModelRequestKt$WhenMappings;
import org.gradle.kotlin.dsl.support.IOKt;
import org.gradle.kotlin.dsl.support.KotlinScriptType;
import org.gradle.kotlin.dsl.support.KotlinScriptTypeKt;
import org.gradle.kotlin.dsl.tooling.models.KotlinBuildScriptModel;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\u0010H\u0007\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0014\u001a\u00020\u0015H\u0000\u001a$\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0000\u001a8\u0010\u0019\u001a&\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u000e0\u000e \u001b*\u0012\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u001a0\u001a*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a/\u0010\u001c\u001a\u00020\b*\u00020\f2!\u0010\u001d\u001a\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001a\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` \u00a2\u0006\u0002\b!H\u0002\u001a\u0014\u0010\"\u001a\u00020\n*\u00020\n2\u0006\u0010#\u001a\u00020$H\u0002*:\b\u0000\u0010%\"\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001a\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\u0002\b!2\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001a\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\u0002\b!\u00a8\u0006&"}, d2={"buildSrcProjectDirOf", "Ljava/io/File;", "scriptFile", "importedProjectDir", "connectionForProjectDir", "Lorg/gradle/tooling/ProjectConnection;", "projectDir", "parameters", "Lorg/gradle/kotlin/dsl/resolver/FetchParameters;", "connectorFor", "Lorg/gradle/tooling/GradleConnector;", "request", "Lorg/gradle/kotlin/dsl/resolver/KotlinBuildScriptModelRequest;", "fetchKotlinBuildScriptModelFor", "Lorg/gradle/kotlin/dsl/tooling/models/KotlinBuildScriptModel;", "connectorForProject", "Ljava/util/function/Function;", "fetchKotlinBuildScriptModelFrom", "hasProjectDependentClassPath", "", "newCorrelationId", "", "projectRootOf", "importedProjectRoot", "stopAt", "modelBuilderFor", "Lorg/gradle/tooling/ModelBuilder;", "kotlin.jvm.PlatformType", "toFetchParametersWith", "modelBuilderCustomization", "Lkotlin/Function1;", "", "Lorg/gradle/kotlin/dsl/resolver/ModelBuilderCustomization;", "Lkotlin/ExtensionFunctionType;", "useGradleFrom", "gradleInstallation", "Lorg/gradle/kotlin/dsl/resolver/GradleInstallation;", "ModelBuilderCustomization", "gradle-kotlin-dsl"})
public final class KotlinBuildScriptModelRequestKt {
    @NotNull
    public static final String newCorrelationId() {
        return String.valueOf(System.nanoTime());
    }

    @NotNull
    public static final KotlinBuildScriptModel fetchKotlinBuildScriptModelFor(@NotNull KotlinBuildScriptModelRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFor(KotlinBuildScriptModelRequestKt.toFetchParametersWith(request, (Function1<? super ModelBuilder<KotlinBuildScriptModel>, Unit>)((Function1)new Function1<ModelBuilder<KotlinBuildScriptModel>, Unit>(request){
            final /* synthetic */ KotlinBuildScriptModelRequest $request;

            public final void invoke(@NotNull ModelBuilder<KotlinBuildScriptModel> $this$toFetchParametersWith) {
                Intrinsics.checkParameterIsNotNull($this$toFetchParametersWith, (String)"$receiver");
                $this$toFetchParametersWith.setJavaHome(this.$request.getJavaHome());
            }
            {
                this.$request = kotlinBuildScriptModelRequest;
                super(1);
            }
        })));
    }

    @VisibleForTesting
    @NotNull
    public static final KotlinBuildScriptModel fetchKotlinBuildScriptModelFor(@NotNull File importedProjectDir, @Nullable File scriptFile, @NotNull Function<File, GradleConnector> connectorForProject) {
        Intrinsics.checkParameterIsNotNull((Object)importedProjectDir, (String)"importedProjectDir");
        Intrinsics.checkParameterIsNotNull(connectorForProject, (String)"connectorForProject");
        return KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFor(new FetchParameters(importedProjectDir, scriptFile, connectorForProject, null, null, null, null, null, 248, null));
    }

    private static final FetchParameters toFetchParametersWith(@NotNull KotlinBuildScriptModelRequest $this$toFetchParametersWith, Function1<? super ModelBuilder<KotlinBuildScriptModel>, Unit> modelBuilderCustomization) {
        return new FetchParameters($this$toFetchParametersWith.getProjectDir(), $this$toFetchParametersWith.getScriptFile(), new Function<File, GradleConnector>($this$toFetchParametersWith){
            final /* synthetic */ KotlinBuildScriptModelRequest $this_toFetchParametersWith;

            public final GradleConnector apply(@NotNull File projectDir) {
                Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
                return KotlinBuildScriptModelRequestKt.access$connectorFor(this.$this_toFetchParametersWith).forProjectDirectory(projectDir);
            }
            {
                this.$this_toFetchParametersWith = kotlinBuildScriptModelRequest;
            }
        }, $this$toFetchParametersWith.getOptions(), $this$toFetchParametersWith.getJvmOptions(), $this$toFetchParametersWith.getEnvironmentVariables(), $this$toFetchParametersWith.getCorrelationId(), modelBuilderCustomization);
    }

    private static final GradleConnector connectorFor(KotlinBuildScriptModelRequest request) {
        GradleConnector gradleConnector = GradleConnector.newConnector();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleConnector, (String)"GradleConnector.newConnector()");
        GradleConnector gradleConnector2 = KotlinBuildScriptModelRequestKt.useGradleFrom(gradleConnector, request.getGradleInstallation()).useGradleUserHomeDir(request.getGradleUserHome());
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleConnector2, (String)"GradleConnector.newConne\u2026r(request.gradleUserHome)");
        return gradleConnector2;
    }

    private static final GradleConnector useGradleFrom(@NotNull GradleConnector $this$useGradleFrom, GradleInstallation gradleInstallation) {
        GradleConnector gradleConnector;
        GradleInstallation gradleInstallation2 = gradleInstallation;
        boolean bl = false;
        boolean bl2 = false;
        GradleInstallation $this$run = gradleInstallation2;
        boolean bl3 = false;
        GradleInstallation gradleInstallation3 = $this$run;
        if (gradleInstallation3 instanceof GradleInstallation.Local) {
            GradleConnector gradleConnector2 = $this$useGradleFrom.useInstallation(((GradleInstallation.Local)$this$run).getDir());
            gradleConnector = gradleConnector2;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleConnector2, (String)"useInstallation(dir)");
        } else if (gradleInstallation3 instanceof GradleInstallation.Remote) {
            GradleConnector gradleConnector3 = $this$useGradleFrom.useDistribution(((GradleInstallation.Remote)$this$run).getUri());
            gradleConnector = gradleConnector3;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleConnector3, (String)"useDistribution(uri)");
        } else if (gradleInstallation3 instanceof GradleInstallation.Version) {
            GradleConnector gradleConnector4 = $this$useGradleFrom.useGradleVersion(((GradleInstallation.Version)$this$run).getNumber());
            gradleConnector = gradleConnector4;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleConnector4, (String)"useGradleVersion(number)");
        } else if (gradleInstallation3 instanceof GradleInstallation.Embedded) {
            GradleConnector gradleConnector5 = $this$useGradleFrom;
            if (gradleConnector5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.tooling.internal.consumer.DefaultGradleConnector");
            }
            DefaultGradleConnector defaultGradleConnector = (DefaultGradleConnector)gradleConnector5;
            boolean bl4 = false;
            boolean bl5 = false;
            DefaultGradleConnector $this$apply = defaultGradleConnector;
            boolean bl6 = false;
            $this$apply.embedded(true);
            $this$apply.useClasspathDistribution();
            gradleConnector = (GradleConnector)defaultGradleConnector;
        } else if (Intrinsics.areEqual((Object)gradleInstallation3, (Object)GradleInstallation.Wrapper.INSTANCE)) {
            GradleConnector gradleConnector6 = $this$useGradleFrom.useBuildDistribution();
            gradleConnector = gradleConnector6;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleConnector6, (String)"useBuildDistribution()");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return gradleConnector;
    }

    private static final KotlinBuildScriptModel fetchKotlinBuildScriptModelFor(FetchParameters parameters2) {
        File externalProjectRoot;
        if (parameters2.getScriptFile() == null) {
            return KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFrom(parameters2.getImportedProjectDir(), parameters2);
        }
        File file = KotlinBuildScriptModelRequestKt.buildSrcProjectDirOf(parameters2.getScriptFile(), parameters2.getImportedProjectDir());
        if (file == null) {
            file = parameters2.getImportedProjectDir();
        }
        File effectiveProjectDir = file;
        KotlinBuildScriptModel scriptModel = KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFrom(effectiveProjectDir, parameters2);
        if (scriptModel.getEnclosingScriptProjectDir() == null && KotlinBuildScriptModelRequestKt.hasProjectDependentClassPath(parameters2.getScriptFile()) && Intrinsics.areEqual((Object)(externalProjectRoot = KotlinBuildScriptModelRequestKt.projectRootOf$default(parameters2.getScriptFile(), parameters2.getImportedProjectDir(), null, 4, null)), (Object)parameters2.getImportedProjectDir()) ^ true) {
            return KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFrom(externalProjectRoot, parameters2);
        }
        return scriptModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final KotlinBuildScriptModel fetchKotlinBuildScriptModelFrom(File projectDir, FetchParameters parameters2) {
        KotlinBuildScriptModel kotlinBuildScriptModel;
        ProjectConnection projectConnection = KotlinBuildScriptModelRequestKt.connectionForProjectDir(projectDir, parameters2);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try (ProjectConnection connection = projectConnection;){
            kotlinBuildScriptModel = KotlinBuildScriptModelRequestKt.modelBuilderFor(connection, parameters2);
            Function1<ModelBuilder<KotlinBuildScriptModel>, Unit> function1 = parameters2.getModelBuilderCustomization();
            boolean bl4 = false;
            boolean bl5 = false;
            function1.invoke(kotlinBuildScriptModel);
            Object object = kotlinBuildScriptModel.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"connection.modelBuilderF\u2026ilderCustomization).get()");
            kotlinBuildScriptModel = (KotlinBuildScriptModel)object;
        }
        KotlinBuildScriptModel kotlinBuildScriptModel2 = kotlinBuildScriptModel;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinBuildScriptModel2, (String)"connectionForProjectDir(\u2026n.close()\n        }\n    }");
        return kotlinBuildScriptModel2;
    }

    private static final ProjectConnection connectionForProjectDir(File projectDir, FetchParameters parameters2) {
        ProjectConnection projectConnection = parameters2.getConnectorForProject().apply(projectDir).connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectConnection, (String)"parameters.connectorForP\u2026ply(projectDir).connect()");
        return projectConnection;
    }

    private static final ModelBuilder<KotlinBuildScriptModel> modelBuilderFor(@NotNull ProjectConnection $this$modelBuilderFor, FetchParameters parameters2) {
        ModelBuilder modelBuilder = $this$modelBuilderFor.model(KotlinBuildScriptModel.class);
        boolean bl = false;
        boolean bl2 = false;
        ModelBuilder $this$apply = modelBuilder;
        boolean bl3 = false;
        Map<String, String> map = parameters2.getEnvironmentVariables();
        ModelBuilder modelBuilder2 = $this$apply;
        boolean bl4 = false;
        boolean bl5 = false;
        Map<String, String> it = map;
        boolean bl6 = false;
        Map<String, String> map2 = it;
        boolean bl7 = false;
        Map<String, String> map3 = !map2.isEmpty() ? map : null;
        modelBuilder2.setEnvironmentVariables(map3);
        $this$apply.setJvmArguments((Iterable)CollectionsKt.plus((Collection)parameters2.getJvmOptions(), (Object)"-Dorg.gradle.kotlin.dsl.provider.mode=classpath"));
        $this$apply.forTasks(new String[]{"prepareKotlinBuildScriptModel"});
        List arguments = CollectionsKt.toMutableList((Collection)parameters2.getOptions());
        Object object = arguments;
        String string2 = "-Porg.gradle.kotlin.dsl.provider.cid=" + parameters2.getCorrelationId();
        boolean bl8 = false;
        object.add(string2);
        File file = parameters2.getScriptFile();
        if (file != null) {
            object = file;
            boolean bl9 = false;
            bl8 = false;
            Object it2 = object;
            boolean bl10 = false;
            Collection collection = arguments;
            String string3 = "-Porg.gradle.kotlin.dsl.provider.script=" + ((File)it2).getCanonicalPath();
            boolean bl11 = false;
            collection.add(string3);
        }
        $this$apply.withArguments((Iterable)arguments);
        return modelBuilder;
    }

    private static final File buildSrcProjectDirOf(File scriptFile, File importedProjectDir) {
        File file = FilesKt.resolve((File)importedProjectDir, (String)"buildSrc");
        boolean bl = false;
        boolean bl2 = false;
        File buildSrc = file;
        boolean bl3 = false;
        return buildSrc.isDirectory() && IOKt.isParentOf(buildSrc, scriptFile) ? file : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasProjectDependentClassPath(File scriptFile) {
        KotlinScriptType kotlinScriptType = KotlinScriptTypeKt.kotlinScriptTypeFor(scriptFile);
        if (kotlinScriptType == null) return true;
        switch (KotlinBuildScriptModelRequestKt$WhenMappings.$EnumSwitchMapping$0[kotlinScriptType.ordinal()]) {
            case 1: {
                return false;
            }
            default: {
                return true;
            }
        }
    }

    @NotNull
    public static final File projectRootOf(@NotNull File scriptFile, @NotNull File importedProjectRoot, @Nullable File stopAt) {
        Intrinsics.checkParameterIsNotNull((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkParameterIsNotNull((Object)importedProjectRoot, (String)"importedProjectRoot");
        projectRootOf.1 $fun$isProjectRoot$1 = projectRootOf.1.INSTANCE;
        Function1<File, File> $fun$test$2 = new Function1<File, File>(importedProjectRoot, stopAt, scriptFile){
            final /* synthetic */ File $importedProjectRoot;
            final /* synthetic */ File $stopAt;
            final /* synthetic */ File $scriptFile;

            @NotNull
            public final File invoke(@NotNull File dir) {
                File file;
                block3: {
                    while (true) {
                        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                        if (Intrinsics.areEqual((Object)dir, (Object)this.$importedProjectRoot)) {
                            file = this.$importedProjectRoot;
                            break block3;
                        }
                        if (projectRootOf.1.INSTANCE.invoke(dir)) {
                            file = dir;
                            break block3;
                        }
                        File parentDir = dir.getParentFile();
                        File file2 = parentDir;
                        if (file2 == null || Intrinsics.areEqual((Object)file2, (Object)dir) || Intrinsics.areEqual((Object)file2, (Object)this.$stopAt)) break;
                        dir = parentDir;
                    }
                    File file3 = this.$scriptFile.getParentFile();
                    file = file3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"when (parentDir) {\n     \u2026entDir)\n                }");
                }
                return file;
            }
            {
                this.$importedProjectRoot = file;
                this.$stopAt = file2;
                this.$scriptFile = file3;
                super(1);
            }
        };
        File file = scriptFile.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"scriptFile.parentFile");
        return $fun$test$2.invoke(file);
    }

    public static /* synthetic */ File projectRootOf$default(File file, File file2, File file3, int n, Object object) {
        if ((n & 4) != 0) {
            file3 = null;
        }
        return KotlinBuildScriptModelRequestKt.projectRootOf(file, file2, file3);
    }

    public static final /* synthetic */ GradleConnector access$connectorFor(KotlinBuildScriptModelRequest request) {
        return KotlinBuildScriptModelRequestKt.connectorFor(request);
    }
}

