/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.BDToolkit;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.videolan.Logger;
import org.videolan.PortingHelper;

public class BDJHelper {
    private static int mouseX = 0;
    private static int mouseY = 0;
    private static int mouseMask = 0;
    private static final Logger logger = Logger.getLogger((String)BDJHelper.class.getName());

    public static EventDispatchThread getEventDispatchThread(EventQueue eq) {
        if (eq != null) {
            return eq.getDispatchThread();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopEventQueue(EventQueue eq) {
        EventDispatchThread t = eq.getDispatchThread();
        if (t != null && t.isAlive()) {
            long DISPOSAL_TIMEOUT = 5000L;
            final Object notificationLock = new Object();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = notificationLock;
                    synchronized (object) {
                        notificationLock.notifyAll();
                    }
                }
            };
            Object object = notificationLock;
            synchronized (object) {
                eq.postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
                try {
                    notificationLock.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            t.stopDispatching();
            if (t.isAlive()) {
                t.interrupt();
            }
            try {
                t.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (t.isAlive()) {
                logger.error("stopEventQueue() failed for " + t);
                PortingHelper.stopThread((Thread)t);
            }
        }
    }

    public static boolean postMouseEvent(int x, int y) {
        mouseX = x;
        mouseY = y;
        return BDJHelper.postMouseEventImpl(503, 0);
    }

    public static boolean postMouseEvent(int id) {
        if (id == 501) {
            mouseMask = 16;
        }
        boolean r = BDJHelper.postMouseEventImpl(id, 1);
        if (id == 502) {
            mouseMask = 0;
        }
        return r;
    }

    private static boolean postMouseEventImpl(int id, int button) {
        EventQueue eq;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getGlobalFocusOwner();
        if (focusOwner != null && (eq = BDToolkit.getEventQueue(focusOwner)) != null) {
            long when = System.currentTimeMillis();
            try {
                eq.postEvent(new MouseEvent(focusOwner, id, when, mouseMask, mouseX, mouseY, id == 500 ? 1 : 0, false, button));
                return true;
            }
            catch (Exception e) {
                logger.error("postMouseEvent failed: " + e);
            }
        }
        return false;
    }

    public static boolean postKeyEvent(int id, int modifiers, int keyCode) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getGlobalFocusOwner();
        if (focusOwner != null) {
            long when = System.currentTimeMillis();
            try {
                KeyEvent event = id == 400 ? new KeyEvent(focusOwner, id, when, modifiers, 0, (char)keyCode) : new KeyEvent(focusOwner, id, when, modifiers, keyCode, '\uffff');
                EventQueue eq = BDToolkit.getEventQueue(focusOwner);
                if (eq != null) {
                    eq.postEvent(event);
                    return true;
                }
            }
            catch (Exception e) {
                logger.error("postKeyEvent failed: " + e);
            }
        } else {
            logger.error("KEY event dropped (no focus owner)");
        }
        return false;
    }
}

